<?php

//------------------------------------------------------------------------
// Copyright (c) 2012 Harish Narayanan <hnarayanan@gmail.com>
//------------------------------------------------------------------------
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
//------------------------------------------------------------------------

// Add support for post thumbnails
if ( function_exists( 'add_theme_support' ) ) {
    add_theme_support( 'post-thumbnails' );
}

// Add new post type for portfolio items
add_action('init', 'tf_portfolio_type_init');
function tf_portfolio_type_init()
{
    $portfolio_labels = array(
	'name' => _x('Portfolio items', 'post type general name'),
	'singular_name' => _x('Portfolio item', 'post type singular name'),
	'all_items' => __('All items'),
	'add_new' => _x('Add new item', 'portfolios'),
	'add_new_item' => __('Add new portfolio item'),
	'edit_item' => __('Edit portfolio item'),
	'new_item' => __('New portfolio item'),
	'view_item' => __('View portfolio item'),
	'search_items' => __('Search portfolio items'),
	'not_found' =>  __('No portfolio items found'),
	'not_found_in_trash' => __('No portfolio items found in trash'),
	'parent_item_colon' => ''
	);
    $args = array(
	'labels' => $portfolio_labels,
	'public' => true,
	'publicly_queryable' => true,
	'show_ui' => true,
	'query_var' => true,
	'rewrite' => true,
	'capability_type' => 'post',
	'hierarchical' => false,
	'menu_position' => 5,
	'supports' => array('title','editor','thumbnail'),
	'has_archive' => 'portfolios'
	);
    register_post_type('portfolio',$args);
}

// Add custom taxonomy for portfolio items
add_action( 'init', 'tf_portfolio_type_taxonomy', 0 );
function tf_portfolio_type_taxonomy()
{

    // Portfolio items are classified into sets
    $set_labels = array(
	'name' => _x( 'Portfolio sets', 'taxonomy general name' ),
	'singular_name' => _x( 'Set', 'taxonomy singular name' ),
	'search_items' =>  __( 'Search in sets' ),
	'all_items' => __( 'All sets' ),
	'most_used_items' => null,
	'parent_item' => null,
	'parent_item_colon' => null,
	'edit_item' => __( 'Edit set' ),
	'update_item' => __( 'Update set' ),
	'add_new_item' => __( 'Add new set' ),
	'new_item_name' => __( 'New set' ),
	'menu_name' => __( 'Portfolio sets' ),
	);
    register_taxonomy('set','portfolio',array(
			  'hierarchical' => true,
			  'labels' => $set_labels,
			  'show_ui' => true,
			  'query_var' => true,
			  'rewrite' => array('slug' => 'set' )
			  ));

    // Portfolio items can be tagged
    $tags_labels = array(
	'name' => _x( 'Portfolio tags', 'taxonomy general name' ),
	'singular_name' => _x( 'Tag', 'taxonomy singular name' ),
	'search_items' =>  __( 'Search in tags' ),
	'popular_items' => __( 'Popular tags' ),
	'all_items' => __( 'All tags' ),
	'most_used_items' => null,
	'parent_item' => null,
	'parent_item_colon' => null,
	'edit_item' => __( 'Edit tag' ),
	'update_item' => __( 'Update tag' ),
	'add_new_item' => __( 'Add new tag' ),
	'new_item_name' => __( 'New tag name' ),
	'separate_items_with_commas' => __( 'Separate tags with commas' ),
	'add_or_remove_items' => __( 'Add or remove tags' ),
	'choose_from_most_used' => __( 'Choose from the most used tags' ),
	'menu_name' => __( 'Portfolio tags' ),
	);
    register_taxonomy('tags', 'portfolio', array(
			  'hierarchical' => false,
			  'labels' => $tags_labels,
			  'show_ui' => true,
			  'update_count_callback' => '_update_post_term_count',
			  'query_var' => true,
			  'rewrite' => array('slug' => 'tag' )
			  ));

}

// Add custom icons for backend portfolio items
add_action( 'admin_head', 'tf_portfolio_type_icons' );
function tf_portfolio_type_icons() {
    ?>
<style type="text/css" media="screen">
    #menu-posts-portfolio .wp-menu-image {
        background: url(<?php bloginfo('url') ?>/wp-content/themes/fluid-portfolio/images/portfolio-icon-small.png) no-repeat 6px !important;
    }
    .icon32-posts-portfolio {
        background: url(<?php bloginfo('url') ?>/wp-content/themes/fluid-portfolio/images/portfolio-icon.png) no-repeat !important;
    }
</style>
<?php }

// Add description field to portfolio items
function tf_portfolio_type_description_box() {
    if ( function_exists('add_meta_box') ) {
	add_meta_box( 'new-meta-boxes', 'Themefit Options', 'new_meta_boxes', 'portfolio', 'normal', 'high' );
    }
}
add_action('admin_menu', 'tf_portfolio_type_description_box');

// Add shortcode for generating custom portfolio galleries
add_shortcode( 'tf_gallery_portfolio', 'tf_portfolio_type_gallery' );
function tf_portfolio_type_gallery( $atts ) {

    // Extract input arguments
    extract( shortcode_atts( array( 'set' => 'all', 'limit' => -1, 'filtertags' => ''), $atts ) );
    $delimiter = ',';
    $inputFilterTags = "{$filtertags}";
    $inputTags = explode($delimiter , $inputFilterTags);

    // Generate output for filter tags
    $filterGallery = $inputFilterTags == '' ? '' : ' tf-filter';
    $imageTagString = '';
    $imageTags = array( );
    $title = '';
    $alt = '';
    $image = '';
    $link = '';
    $class = '';
    $html = '<div class="tf-gallery-wrapper'.$filterGallery.'" >';
    $html .= '<ul id="tf-sub-page-nav" class="tf-filter-menu">';
    $html .= '<li class="tf-filter-menu-item all"><a class="all">' . __('All', 'domain-themefit-fluid') . '</a></li>';
    foreach($inputTags as $tag) {
	$tag = trim($tag);
	$class = str_replace(' ', '-', $tag);
	$html .= '<li class="tf-filter-menu-item '.$class.'"><a class="'.$class.'">'.ucfirst($tag).'</a></li>';
    }
    $html .= '</ul>';

    // Generate actual gallery
    $html .= '<ul class="tf-gallery-list">';
    $postquery = array( 'post_type' => 'portfolio', 'numberposts' => $limit, 'orderby' => 'date', 'order'=> 'ASC');
    if(strcmp($set, 'all') != 0)
    {
	$postquery += array( 'set' => $set );
    }

    $postslist = get_posts( $postquery );
    foreach ($postslist as $post) {
	setup_postdata($post);
	$id = $post->ID;
	$title = get_the_title($id);
	$alt = get_post_meta($id, '_wp_attachment_image_alt', true);//fixme
	if (has_post_thumbnail( $id ) ):
	    $image = wp_get_attachment_image_src( get_post_thumbnail_id( $id ), 'single-post-thumbnail' );
	endif;
	$link = get_permalink($id);


	$imageTagString = '';
	$imageTags = wp_get_post_terms($id, 'tags');
	foreach($imageTags as $tag) {
	    $imageTagString .= ' ' . strtolower($tag->name);
	}

	if($link == '') { $link = '#'; } // eliminate broken links

	$html .= '<li class="tf-gallery-list-item'.$imageTagString.'">';
	$html .= '<a class="tf-gallery-link" href="'.$link.'" title="'.$title.'" target="_self"></a>';
	$html .= '<div class="tf-gallery-image-container"><img class="tf-gallery-image tf-gallery-image-' . $id . '" src="'.$image[0].'" alt="'.$alt.'" title="'.$title.'"  /></div>';
	$html .= '<div class="tf-gallery-controls primary-color-background">';
	$html .= '<a class="tf-gallery-title" href="'.$link.'" title="'.$title.'" target="_self">'.$title.'</a>';
	$html .= '<a class="tf-gallery-icon accent-color-background" href="'.$link.'" title="'.$title.'" target="_self"></a>';
	$html .= '</div>';
	$html .= '</li>';
    }

    $html .= '</ul>';
    $html .= '</div>';

    return $html;
}

?>