<?php
/*
Template Name: Portfolio Project
*/

global $post;
$nextState = '';
$arrChildren = array();
$sets = get_the_terms($post->ID, 'set');
foreach($sets as $temp)
{
    $set = $temp->name;
}
$args = array('post_type' => 'portfolio', 'set' => $set,
	      'orderby' => 'post_date', 'order' => 'ASC');
$children = get_posts($args);
$prevID = 0;
$currentID = 0;
$nextID = 0;

foreach ($children as $child) {
   $arrChildren[] += $child->ID;
}

$currentID = array_search($post->ID, $arrChildren);
$prevID = $arrChildren[$currentID-1];
$nextID = $arrChildren[$currentID+1];

!empty($prevID) ? $prevState = 'href="'.get_permalink($prevID).'"' : $prevState = 'class="disabled"';
!empty($nextID) ? $nextState = 'href="'.get_permalink($nextID).'"' : $nextState = 'class="disabled"';

get_header(); ?>
    
    <div class="page">
    
	<?php if (have_posts()) : while (have_posts()) : the_post(); ?>
            
            <div id="tf-portfolio-project" class="border-styles">
            
				<div id="tf-headings" class="primary-color-text">
                
					<div id="tf-headings-left-col">
    <p><?php echo $set;
echo '<br />';
printf(__('%1$s / %2$s', 'domain-themefit-fluid'), ($currentID+1), count($arrChildren)); ?></p>
                    </div>
                    
					<div id="tf-headings-right-col" class="border-styles">
						<h2><?php the_title() ?></h2>
						<div id="tf-prev-next-menu">
							<a <?php echo $prevState; ?> ><?php _e('Prev', 'domain-themefit-fluid'); ?></a> / <a <?php echo $nextState; ?>><?php _e('Next', 'domain-themefit-fluid'); ?></a>
						</div>
					</div>
                    
				</div>
                
				<div id="tf-project-left-col">
					<p><?php echo get_post_meta($post->ID, "_tf_project_desc_value", true); ?></p>
				</div>
                
				<div id="tf-project-right-col" class="border-styles">
					<?php the_content(); ?>
                    <?php comments_template(); ?>
        		</div>
            
			</div>
    
	<?php endwhile; endif; ?>
    
    </div>

<?php get_footer(); ?>